// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary>
    /// The base definition of a secret type.
    /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
    /// </summary>
    public partial class SecretBase
    {
        /// <summary> Initializes a new instance of <see cref="SecretBase"/>. </summary>
        public SecretBase()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecretBase"/>. </summary>
        /// <param name="type"> Type of the secret. </param>
        internal SecretBase(string type)
        {
            Type = type;
        }

        /// <summary> Type of the secret. </summary>
        internal string Type { get; set; }
    }
}
