// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The type of the ScriptActivityScriptBlock. </summary>
    internal readonly partial struct ScriptType : IEquatable<ScriptType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueryValue = "Query";
        private const string NonQueryValue = "NonQuery";

        /// <summary> Query. </summary>
        public static ScriptType Query { get; } = new ScriptType(QueryValue);
        /// <summary> NonQuery. </summary>
        public static ScriptType NonQuery { get; } = new ScriptType(NonQueryValue);
        /// <summary> Determines if two <see cref="ScriptType"/> values are the same. </summary>
        public static bool operator ==(ScriptType left, ScriptType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptType"/> values are not the same. </summary>
        public static bool operator !=(ScriptType left, ScriptType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptType"/>. </summary>
        public static implicit operator ScriptType(string value) => new ScriptType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
