// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Parameters of a script block. </summary>
    public partial class ScriptActivityParameter
    {
        /// <summary> Initializes a new instance of <see cref="ScriptActivityParameter"/>. </summary>
        public ScriptActivityParameter()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScriptActivityParameter"/>. </summary>
        /// <param name="name"> The name of the parameter. Type: string (or Expression with resultType string). </param>
        /// <param name="type"> The type of the parameter. </param>
        /// <param name="value"> The value of the parameter. </param>
        /// <param name="direction"> The direction of the parameter. </param>
        /// <param name="size"> The size of the output direction parameter. </param>
        internal ScriptActivityParameter(object name, ScriptActivityParameterType? type, object value, ScriptActivityParameterDirection? direction, int? size)
        {
            Name = name;
            Type = type;
            Value = value;
            Direction = direction;
            Size = size;
        }

        /// <summary> The name of the parameter. Type: string (or Expression with resultType string). </summary>
        public object Name { get; set; }
        /// <summary> The type of the parameter. </summary>
        public ScriptActivityParameterType? Type { get; set; }
        /// <summary> The value of the parameter. </summary>
        public object Value { get; set; }
        /// <summary> The direction of the parameter. </summary>
        public ScriptActivityParameterDirection? Direction { get; set; }
        /// <summary> The size of the output direction parameter. </summary>
        public int? Size { get; set; }
    }
}
