// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Trigger that creates pipeline runs periodically, on schedule. </summary>
    public partial class ScheduleTrigger : MultiplePipelineTrigger
    {
        /// <summary> Initializes a new instance of <see cref="ScheduleTrigger"/>. </summary>
        /// <param name="recurrence"> Recurrence schedule configuration. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recurrence"/> is null. </exception>
        public ScheduleTrigger(ScheduleTriggerRecurrence recurrence)
        {
            Argument.AssertNotNull(recurrence, nameof(recurrence));

            Recurrence = recurrence;
            Type = "ScheduleTrigger";
        }

        /// <summary> Initializes a new instance of <see cref="ScheduleTrigger"/>. </summary>
        /// <param name="type"> Trigger type. </param>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="recurrence"> Recurrence schedule configuration. </param>
        internal ScheduleTrigger(string type, string description, TriggerRuntimeState? runtimeState, IList<object> annotations, IDictionary<string, object> additionalProperties, IList<TriggerPipelineReference> pipelines, ScheduleTriggerRecurrence recurrence) : base(type, description, runtimeState, annotations, additionalProperties, pipelines)
        {
            Recurrence = recurrence;
            Type = type ?? "ScheduleTrigger";
        }

        /// <summary> Recurrence schedule configuration. </summary>
        public ScheduleTriggerRecurrence Recurrence { get; set; }
    }
}
