// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The partition mechanism that will be used for SAP table read in parallel. </summary>
    internal readonly partial struct SapTablePartitionOption : IEquatable<SapTablePartitionOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapTablePartitionOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapTablePartitionOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PartitionOnIntValue = "PartitionOnInt";
        private const string PartitionOnCalendarYearValue = "PartitionOnCalendarYear";
        private const string PartitionOnCalendarMonthValue = "PartitionOnCalendarMonth";
        private const string PartitionOnCalendarDateValue = "PartitionOnCalendarDate";
        private const string PartitionOnTimeValue = "PartitionOnTime";

        /// <summary> None. </summary>
        public static SapTablePartitionOption None { get; } = new SapTablePartitionOption(NoneValue);
        /// <summary> PartitionOnInt. </summary>
        public static SapTablePartitionOption PartitionOnInt { get; } = new SapTablePartitionOption(PartitionOnIntValue);
        /// <summary> PartitionOnCalendarYear. </summary>
        public static SapTablePartitionOption PartitionOnCalendarYear { get; } = new SapTablePartitionOption(PartitionOnCalendarYearValue);
        /// <summary> PartitionOnCalendarMonth. </summary>
        public static SapTablePartitionOption PartitionOnCalendarMonth { get; } = new SapTablePartitionOption(PartitionOnCalendarMonthValue);
        /// <summary> PartitionOnCalendarDate. </summary>
        public static SapTablePartitionOption PartitionOnCalendarDate { get; } = new SapTablePartitionOption(PartitionOnCalendarDateValue);
        /// <summary> PartitionOnTime. </summary>
        public static SapTablePartitionOption PartitionOnTime { get; } = new SapTablePartitionOption(PartitionOnTimeValue);
        /// <summary> Determines if two <see cref="SapTablePartitionOption"/> values are the same. </summary>
        public static bool operator ==(SapTablePartitionOption left, SapTablePartitionOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapTablePartitionOption"/> values are not the same. </summary>
        public static bool operator !=(SapTablePartitionOption left, SapTablePartitionOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapTablePartitionOption"/>. </summary>
        public static implicit operator SapTablePartitionOption(string value) => new SapTablePartitionOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapTablePartitionOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapTablePartitionOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
