// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity source for SAP ODP source. </summary>
    public partial class SapOdpSource : TabularSource
    {
        /// <summary> Initializes a new instance of <see cref="SapOdpSource"/>. </summary>
        public SapOdpSource()
        {
            Type = "SapOdpSource";
        }

        /// <summary> Initializes a new instance of <see cref="SapOdpSource"/>. </summary>
        /// <param name="type"> Copy source type. </param>
        /// <param name="sourceRetryCount"> Source retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sourceRetryWait"> Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="queryTimeout"> Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="additionalColumns"> Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects). </param>
        /// <param name="extractionMode"> The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string). </param>
        /// <param name="subscriberProcess"> The subscriber process to manage the delta process. Type: string (or Expression with resultType string). </param>
        /// <param name="selection"> Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects). </param>
        /// <param name="projection"> Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects). </param>
        internal SapOdpSource(string type, object sourceRetryCount, object sourceRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object queryTimeout, object additionalColumns, object extractionMode, object subscriberProcess, object selection, object projection) : base(type, sourceRetryCount, sourceRetryWait, maxConcurrentConnections, additionalProperties, queryTimeout, additionalColumns)
        {
            ExtractionMode = extractionMode;
            SubscriberProcess = subscriberProcess;
            Selection = selection;
            Projection = projection;
            Type = type ?? "SapOdpSource";
        }

        /// <summary> The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string). </summary>
        public object ExtractionMode { get; set; }
        /// <summary> The subscriber process to manage the delta process. Type: string (or Expression with resultType string). </summary>
        public object SubscriberProcess { get; set; }
        /// <summary> Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects). </summary>
        public object Selection { get; set; }
        /// <summary> Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects). </summary>
        public object Projection { get; set; }
    }
}
