// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> SAP ODP Linked Service. </summary>
    public partial class SapOdpLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="SapOdpLinkedService"/>. </summary>
        public SapOdpLinkedService()
        {
            Type = "SapOdp";
        }

        /// <summary> Initializes a new instance of <see cref="SapOdpLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="server"> Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="systemNumber"> System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string). </param>
        /// <param name="clientId"> Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string). </param>
        /// <param name="language"> Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string). </param>
        /// <param name="systemId"> SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="userName"> Username to access the SAP server where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="password">
        /// Password to access the SAP server where the table is located.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="messageServer"> The hostname of the SAP Message Server. Type: string (or Expression with resultType string). </param>
        /// <param name="messageServerService"> The service name or port number of the Message Server. Type: string (or Expression with resultType string). </param>
        /// <param name="sncMode"> SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string). </param>
        /// <param name="sncMyName"> Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="sncPartnerName"> Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="sncLibraryPath"> External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string). </param>
        /// <param name="sncQop"> SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string). </param>
        /// <param name="x509CertificatePath"> SNC X509 certificate file path. Type: string (or Expression with resultType string). </param>
        /// <param name="logonGroup"> The Logon Group for the SAP System. Type: string (or Expression with resultType string). </param>
        /// <param name="subscriberName"> The subscriber name. Type: string (or Expression with resultType string). </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        internal SapOdpLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object server, object systemNumber, object clientId, object language, object systemId, object userName, SecretBase password, object messageServer, object messageServerService, object sncMode, object sncMyName, object sncPartnerName, object sncLibraryPath, object sncQop, object x509CertificatePath, object logonGroup, object subscriberName, object encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            Server = server;
            SystemNumber = systemNumber;
            ClientId = clientId;
            Language = language;
            SystemId = systemId;
            UserName = userName;
            Password = password;
            MessageServer = messageServer;
            MessageServerService = messageServerService;
            SncMode = sncMode;
            SncMyName = sncMyName;
            SncPartnerName = sncPartnerName;
            SncLibraryPath = sncLibraryPath;
            SncQop = sncQop;
            X509CertificatePath = x509CertificatePath;
            LogonGroup = logonGroup;
            SubscriberName = subscriberName;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "SapOdp";
        }

        /// <summary> Host name of the SAP instance where the table is located. Type: string (or Expression with resultType string). </summary>
        public object Server { get; set; }
        /// <summary> System number of the SAP system where the table is located. (Usually a two-digit decimal number represented as a string.) Type: string (or Expression with resultType string). </summary>
        public object SystemNumber { get; set; }
        /// <summary> Client ID of the client on the SAP system where the table is located. (Usually a three-digit decimal number represented as a string) Type: string (or Expression with resultType string). </summary>
        public object ClientId { get; set; }
        /// <summary> Language of the SAP system where the table is located. The default value is EN. Type: string (or Expression with resultType string). </summary>
        public object Language { get; set; }
        /// <summary> SystemID of the SAP system where the table is located. Type: string (or Expression with resultType string). </summary>
        public object SystemId { get; set; }
        /// <summary> Username to access the SAP server where the table is located. Type: string (or Expression with resultType string). </summary>
        public object UserName { get; set; }
        /// <summary>
        /// Password to access the SAP server where the table is located.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase Password { get; set; }
        /// <summary> The hostname of the SAP Message Server. Type: string (or Expression with resultType string). </summary>
        public object MessageServer { get; set; }
        /// <summary> The service name or port number of the Message Server. Type: string (or Expression with resultType string). </summary>
        public object MessageServerService { get; set; }
        /// <summary> SNC activation indicator to access the SAP server where the table is located. Must be either 0 (off) or 1 (on). Type: string (or Expression with resultType string). </summary>
        public object SncMode { get; set; }
        /// <summary> Initiator's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string). </summary>
        public object SncMyName { get; set; }
        /// <summary> Communication partner's SNC name to access the SAP server where the table is located. Type: string (or Expression with resultType string). </summary>
        public object SncPartnerName { get; set; }
        /// <summary> External security product's library to access the SAP server where the table is located. Type: string (or Expression with resultType string). </summary>
        public object SncLibraryPath { get; set; }
        /// <summary> SNC Quality of Protection. Allowed value include: 1, 2, 3, 8, 9. Type: string (or Expression with resultType string). </summary>
        public object SncQop { get; set; }
        /// <summary> SNC X509 certificate file path. Type: string (or Expression with resultType string). </summary>
        public object X509CertificatePath { get; set; }
        /// <summary> The Logon Group for the SAP System. Type: string (or Expression with resultType string). </summary>
        public object LogonGroup { get; set; }
        /// <summary> The subscriber name. Type: string (or Expression with resultType string). </summary>
        public object SubscriberName { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public object EncryptedCredential { get; set; }
    }
}
