// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity Salesforce V2 source. </summary>
    public partial class SalesforceV2Source : TabularSource
    {
        /// <summary> Initializes a new instance of <see cref="SalesforceV2Source"/>. </summary>
        public SalesforceV2Source()
        {
            Type = "SalesforceV2Source";
        }

        /// <summary> Initializes a new instance of <see cref="SalesforceV2Source"/>. </summary>
        /// <param name="type"> Copy source type. </param>
        /// <param name="sourceRetryCount"> Source retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sourceRetryWait"> Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="queryTimeout"> Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="additionalColumns"> Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects). </param>
        /// <param name="soqlQuery"> Database query. Type: string (or Expression with resultType string). </param>
        /// <param name="includeDeletedObjects"> This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean). </param>
        internal SalesforceV2Source(string type, object sourceRetryCount, object sourceRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object queryTimeout, object additionalColumns, object soqlQuery, object includeDeletedObjects) : base(type, sourceRetryCount, sourceRetryWait, maxConcurrentConnections, additionalProperties, queryTimeout, additionalColumns)
        {
            SoqlQuery = soqlQuery;
            IncludeDeletedObjects = includeDeletedObjects;
            Type = type ?? "SalesforceV2Source";
        }

        /// <summary> Database query. Type: string (or Expression with resultType string). </summary>
        public object SoqlQuery { get; set; }
        /// <summary> This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean). </summary>
        public object IncludeDeletedObjects { get; set; }
    }
}
