// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The Salesforce V2 object dataset. </summary>
    public partial class SalesforceV2ObjectDataset : Dataset
    {
        /// <summary> Initializes a new instance of <see cref="SalesforceV2ObjectDataset"/>. </summary>
        /// <param name="linkedServiceName"> Linked service reference. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkedServiceName"/> is null. </exception>
        public SalesforceV2ObjectDataset(LinkedServiceReference linkedServiceName) : base(linkedServiceName)
        {
            Argument.AssertNotNull(linkedServiceName, nameof(linkedServiceName));

            Type = "SalesforceV2Object";
        }

        /// <summary> Initializes a new instance of <see cref="SalesforceV2ObjectDataset"/>. </summary>
        /// <param name="type"> Type of dataset. </param>
        /// <param name="description"> Dataset description. </param>
        /// <param name="structure"> Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement. </param>
        /// <param name="schema"> Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement. </param>
        /// <param name="linkedServiceName"> Linked service reference. </param>
        /// <param name="parameters"> Parameters for dataset. </param>
        /// <param name="annotations"> List of tags that can be used for describing the Dataset. </param>
        /// <param name="folder"> The folder that this Dataset is in. If not specified, Dataset will appear at the root level. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="objectApiName"> The Salesforce V2 object API name. Type: string (or Expression with resultType string). </param>
        /// <param name="reportId"> The Salesforce V2 report Id. Type: string (or Expression with resultType string). </param>
        internal SalesforceV2ObjectDataset(string type, string description, object structure, object schema, LinkedServiceReference linkedServiceName, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, DatasetFolder folder, IDictionary<string, object> additionalProperties, object objectApiName, object reportId) : base(type, description, structure, schema, linkedServiceName, parameters, annotations, folder, additionalProperties)
        {
            ObjectApiName = objectApiName;
            ReportId = reportId;
            Type = type ?? "SalesforceV2Object";
        }

        /// <summary> The Salesforce V2 object API name. Type: string (or Expression with resultType string). </summary>
        public object ObjectApiName { get; set; }
        /// <summary> The Salesforce V2 report Id. Type: string (or Expression with resultType string). </summary>
        public object ReportId { get; set; }
    }
}
