// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The Salesforce read behavior for the operation. </summary>
    internal readonly partial struct SalesforceSourceReadBehavior : IEquatable<SalesforceSourceReadBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SalesforceSourceReadBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SalesforceSourceReadBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueryValue = "Query";
        private const string QueryAllValue = "QueryAll";

        /// <summary> Query. </summary>
        public static SalesforceSourceReadBehavior Query { get; } = new SalesforceSourceReadBehavior(QueryValue);
        /// <summary> QueryAll. </summary>
        public static SalesforceSourceReadBehavior QueryAll { get; } = new SalesforceSourceReadBehavior(QueryAllValue);
        /// <summary> Determines if two <see cref="SalesforceSourceReadBehavior"/> values are the same. </summary>
        public static bool operator ==(SalesforceSourceReadBehavior left, SalesforceSourceReadBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SalesforceSourceReadBehavior"/> values are not the same. </summary>
        public static bool operator !=(SalesforceSourceReadBehavior left, SalesforceSourceReadBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SalesforceSourceReadBehavior"/>. </summary>
        public static implicit operator SalesforceSourceReadBehavior(string value) => new SalesforceSourceReadBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SalesforceSourceReadBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SalesforceSourceReadBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
