// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity Salesforce Service Cloud V2 source. </summary>
    public partial class SalesforceServiceCloudV2Source : CopySource
    {
        /// <summary> Initializes a new instance of <see cref="SalesforceServiceCloudV2Source"/>. </summary>
        public SalesforceServiceCloudV2Source()
        {
            Type = "SalesforceServiceCloudV2Source";
        }

        /// <summary> Initializes a new instance of <see cref="SalesforceServiceCloudV2Source"/>. </summary>
        /// <param name="type"> Copy source type. </param>
        /// <param name="sourceRetryCount"> Source retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sourceRetryWait"> Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="soqlQuery"> Database query. Type: string (or Expression with resultType string). </param>
        /// <param name="includeDeletedObjects"> This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="additionalColumns"> Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects). </param>
        internal SalesforceServiceCloudV2Source(string type, object sourceRetryCount, object sourceRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object soqlQuery, object includeDeletedObjects, object additionalColumns) : base(type, sourceRetryCount, sourceRetryWait, maxConcurrentConnections, additionalProperties)
        {
            SoqlQuery = soqlQuery;
            IncludeDeletedObjects = includeDeletedObjects;
            AdditionalColumns = additionalColumns;
            Type = type ?? "SalesforceServiceCloudV2Source";
        }

        /// <summary> Database query. Type: string (or Expression with resultType string). </summary>
        public object SoqlQuery { get; set; }
        /// <summary> This property control whether query result contains Deleted objects. Default is false. Type: boolean (or Expression with resultType boolean). </summary>
        public object IncludeDeletedObjects { get; set; }
        /// <summary> Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects). </summary>
        public object AdditionalColumns { get; set; }
    }
}
