// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(RunQueryOrderByConverter))]
    public partial class RunQueryOrderBy : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("orderBy"u8);
            writer.WriteStringValue(OrderBy.ToString());
            writer.WritePropertyName("order"u8);
            writer.WriteStringValue(Order.ToString());
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class RunQueryOrderByConverter : JsonConverter<RunQueryOrderBy>
        {
            public override void Write(Utf8JsonWriter writer, RunQueryOrderBy model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override RunQueryOrderBy Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }
        }
    }
}
