// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The RunNotebookSparkSessionOptions. </summary>
    public partial class RunNotebookSparkSessionOptions
    {
        /// <summary> Initializes a new instance of <see cref="RunNotebookSparkSessionOptions"/>. </summary>
        public RunNotebookSparkSessionOptions()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Jars = new ChangeTrackingList<string>();
            PythonFiles = new ChangeTrackingList<string>();
            Files = new ChangeTrackingList<string>();
            Archives = new ChangeTrackingList<string>();
            Configuration = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="RunNotebookSparkSessionOptions"/>. </summary>
        /// <param name="tags"> Dictionary of &lt;string&gt;. </param>
        /// <param name="kind"> The session kind. </param>
        /// <param name="proxyUser"> User to impersonate when starting the session. </param>
        /// <param name="name"> The name of this session. </param>
        /// <param name="jars"> jars to be used in this session. </param>
        /// <param name="pythonFiles"> Python files to be used in this session. </param>
        /// <param name="files"> files to be used in this session. </param>
        /// <param name="archives"> Archives to be used in this session. </param>
        /// <param name="queue"> The name of the YARN queue to which submitted. </param>
        /// <param name="configuration"> Spark configuration properties. </param>
        /// <param name="driverMemory"> Amount of memory to use for the driver process. </param>
        /// <param name="driverCores"> Number of cores to use for the driver process. </param>
        /// <param name="executorMemory"> Amount of memory to use per executor process. </param>
        /// <param name="executorCores"> Number of cores to use for each executor. </param>
        /// <param name="executorCount"> Number of executors to launch for this session. </param>
        /// <param name="isQueueable"> Whether to queue session creation if Spark pool doesn't have enough capacity. Default value is true in notebook runs API. </param>
        /// <param name="heartbeatTimeoutInSecond"> Timeout in second to which session be orphaned. </param>
        internal RunNotebookSparkSessionOptions(IDictionary<string, string> tags, string kind, string proxyUser, string name, IList<string> jars, IList<string> pythonFiles, IList<string> files, IList<string> archives, object queue, IDictionary<string, string> configuration, string driverMemory, int? driverCores, string executorMemory, int? executorCores, int? executorCount, bool? isQueueable, int? heartbeatTimeoutInSecond)
        {
            Tags = tags;
            Kind = kind;
            ProxyUser = proxyUser;
            Name = name;
            Jars = jars;
            PythonFiles = pythonFiles;
            Files = files;
            Archives = archives;
            Queue = queue;
            Configuration = configuration;
            DriverMemory = driverMemory;
            DriverCores = driverCores;
            ExecutorMemory = executorMemory;
            ExecutorCores = executorCores;
            ExecutorCount = executorCount;
            IsQueueable = isQueueable;
            HeartbeatTimeoutInSecond = heartbeatTimeoutInSecond;
        }

        /// <summary> Dictionary of &lt;string&gt;. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The session kind. </summary>
        public string Kind { get; set; }
        /// <summary> User to impersonate when starting the session. </summary>
        public string ProxyUser { get; set; }
        /// <summary> The name of this session. </summary>
        public string Name { get; set; }
        /// <summary> jars to be used in this session. </summary>
        public IList<string> Jars { get; }
        /// <summary> Python files to be used in this session. </summary>
        public IList<string> PythonFiles { get; }
        /// <summary> files to be used in this session. </summary>
        public IList<string> Files { get; }
        /// <summary> Archives to be used in this session. </summary>
        public IList<string> Archives { get; }
        /// <summary> The name of the YARN queue to which submitted. </summary>
        public object Queue { get; set; }
        /// <summary> Spark configuration properties. </summary>
        public IDictionary<string, string> Configuration { get; }
        /// <summary> Amount of memory to use for the driver process. </summary>
        public string DriverMemory { get; set; }
        /// <summary> Number of cores to use for the driver process. </summary>
        public int? DriverCores { get; set; }
        /// <summary> Amount of memory to use per executor process. </summary>
        public string ExecutorMemory { get; set; }
        /// <summary> Number of cores to use for each executor. </summary>
        public int? ExecutorCores { get; set; }
        /// <summary> Number of executors to launch for this session. </summary>
        public int? ExecutorCount { get; set; }
        /// <summary> Whether to queue session creation if Spark pool doesn't have enough capacity. Default value is true in notebook runs API. </summary>
        public bool? IsQueueable { get; set; }
        /// <summary> Timeout in second to which session be orphaned. </summary>
        public int? HeartbeatTimeoutInSecond { get; set; }
    }
}
