// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(RunNotebookSparkSessionOptionsConverter))]
    public partial class RunNotebookSparkSessionOptions : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind);
            }
            if (Optional.IsDefined(ProxyUser))
            {
                writer.WritePropertyName("proxyUser"u8);
                writer.WriteStringValue(ProxyUser);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsCollectionDefined(Jars))
            {
                writer.WritePropertyName("jars"u8);
                writer.WriteStartArray();
                foreach (var item in Jars)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PythonFiles))
            {
                writer.WritePropertyName("pyFiles"u8);
                writer.WriteStartArray();
                foreach (var item in PythonFiles)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Files))
            {
                writer.WritePropertyName("files"u8);
                writer.WriteStartArray();
                foreach (var item in Files)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Archives))
            {
                writer.WritePropertyName("archives"u8);
                writer.WriteStartArray();
                foreach (var item in Archives)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Queue))
            {
                writer.WritePropertyName("queue"u8);
                writer.WriteObjectValue<object>(Queue);
            }
            if (Optional.IsCollectionDefined(Configuration))
            {
                writer.WritePropertyName("conf"u8);
                writer.WriteStartObject();
                foreach (var item in Configuration)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(DriverMemory))
            {
                writer.WritePropertyName("driverMemory"u8);
                writer.WriteStringValue(DriverMemory);
            }
            if (Optional.IsDefined(DriverCores))
            {
                writer.WritePropertyName("driverCores"u8);
                writer.WriteNumberValue(DriverCores.Value);
            }
            if (Optional.IsDefined(ExecutorMemory))
            {
                writer.WritePropertyName("executorMemory"u8);
                writer.WriteStringValue(ExecutorMemory);
            }
            if (Optional.IsDefined(ExecutorCores))
            {
                writer.WritePropertyName("executorCores"u8);
                writer.WriteNumberValue(ExecutorCores.Value);
            }
            if (Optional.IsDefined(ExecutorCount))
            {
                writer.WritePropertyName("numExecutors"u8);
                writer.WriteNumberValue(ExecutorCount.Value);
            }
            if (Optional.IsDefined(IsQueueable))
            {
                writer.WritePropertyName("isQueueable"u8);
                writer.WriteBooleanValue(IsQueueable.Value);
            }
            if (Optional.IsDefined(HeartbeatTimeoutInSecond))
            {
                writer.WritePropertyName("heartbeatTimeoutInSecond"u8);
                writer.WriteNumberValue(HeartbeatTimeoutInSecond.Value);
            }
            writer.WriteEndObject();
        }

        internal static RunNotebookSparkSessionOptions DeserializeRunNotebookSparkSessionOptions(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            string kind = default;
            string proxyUser = default;
            string name = default;
            IList<string> jars = default;
            IList<string> pyFiles = default;
            IList<string> files = default;
            IList<string> archives = default;
            object queue = default;
            IDictionary<string, string> conf = default;
            string driverMemory = default;
            int? driverCores = default;
            string executorMemory = default;
            int? executorCores = default;
            int? numExecutors = default;
            bool? isQueueable = default;
            int? heartbeatTimeoutInSecond = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("kind"u8))
                {
                    kind = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("proxyUser"u8))
                {
                    proxyUser = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("jars"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    jars = array;
                    continue;
                }
                if (property.NameEquals("pyFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    pyFiles = array;
                    continue;
                }
                if (property.NameEquals("files"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    files = array;
                    continue;
                }
                if (property.NameEquals("archives"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    archives = array;
                    continue;
                }
                if (property.NameEquals("queue"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queue = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("conf"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    conf = dictionary;
                    continue;
                }
                if (property.NameEquals("driverMemory"u8))
                {
                    driverMemory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("driverCores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    driverCores = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("executorMemory"u8))
                {
                    executorMemory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("executorCores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executorCores = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("numExecutors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numExecutors = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isQueueable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isQueueable = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("heartbeatTimeoutInSecond"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    heartbeatTimeoutInSecond = property.Value.GetInt32();
                    continue;
                }
            }
            return new RunNotebookSparkSessionOptions(
                tags ?? new ChangeTrackingDictionary<string, string>(),
                kind,
                proxyUser,
                name,
                jars ?? new ChangeTrackingList<string>(),
                pyFiles ?? new ChangeTrackingList<string>(),
                files ?? new ChangeTrackingList<string>(),
                archives ?? new ChangeTrackingList<string>(),
                queue,
                conf ?? new ChangeTrackingDictionary<string, string>(),
                driverMemory,
                driverCores,
                executorMemory,
                executorCores,
                numExecutors,
                isQueueable,
                heartbeatTimeoutInSecond);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RunNotebookSparkSessionOptions FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRunNotebookSparkSessionOptions(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class RunNotebookSparkSessionOptionsConverter : JsonConverter<RunNotebookSparkSessionOptions>
        {
            public override void Write(Utf8JsonWriter writer, RunNotebookSparkSessionOptions model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override RunNotebookSparkSessionOptions Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeRunNotebookSparkSessionOptions(document.RootElement);
            }
        }
    }
}
