// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Run notebook snapshot. </summary>
    public partial class RunNotebookSnapshot
    {
        /// <summary> Initializes a new instance of <see cref="RunNotebookSnapshot"/>. </summary>
        /// <param name="id"> Run notebook runId. </param>
        /// <param name="notebook"> Notebook name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="notebook"/> is null. </exception>
        internal RunNotebookSnapshot(string id, string notebook)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(notebook, nameof(notebook));

            Id = id;
            Notebook = notebook;
            Parameters = new ChangeTrackingDictionary<string, RunNotebookParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="RunNotebookSnapshot"/>. </summary>
        /// <param name="exitValue"> Output of exit command. </param>
        /// <param name="id"> Run notebook runId. </param>
        /// <param name="notebook"> Notebook name. </param>
        /// <param name="sessionOptions"> Session properties. </param>
        /// <param name="honorSessionTimeToLive"> Whether session should run till time to live after run completes. </param>
        /// <param name="sessionId"> Livy session id. </param>
        /// <param name="sparkPool"> SparkPool name. </param>
        /// <param name="parameters"> Run notebook parameters. </param>
        /// <param name="notebookContent"> Notebook resource type. </param>
        internal RunNotebookSnapshot(string exitValue, string id, string notebook, RunNotebookSparkSessionOptions sessionOptions, bool? honorSessionTimeToLive, string sessionId, string sparkPool, IReadOnlyDictionary<string, RunNotebookParameter> parameters, NotebookResource notebookContent)
        {
            ExitValue = exitValue;
            Id = id;
            Notebook = notebook;
            SessionOptions = sessionOptions;
            HonorSessionTimeToLive = honorSessionTimeToLive;
            SessionId = sessionId;
            SparkPool = sparkPool;
            Parameters = parameters;
            NotebookContent = notebookContent;
        }

        /// <summary> Output of exit command. </summary>
        public string ExitValue { get; }
        /// <summary> Run notebook runId. </summary>
        public string Id { get; }
        /// <summary> Notebook name. </summary>
        public string Notebook { get; }
        /// <summary> Session properties. </summary>
        public RunNotebookSparkSessionOptions SessionOptions { get; }
        /// <summary> Whether session should run till time to live after run completes. </summary>
        public bool? HonorSessionTimeToLive { get; }
        /// <summary> Livy session id. </summary>
        public string SessionId { get; }
        /// <summary> SparkPool name. </summary>
        public string SparkPool { get; }
        /// <summary> Run notebook parameters. </summary>
        public IReadOnlyDictionary<string, RunNotebookParameter> Parameters { get; }
        /// <summary> Notebook resource type. </summary>
        public NotebookResource NotebookContent { get; }
    }
}
