// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Run notebook request. </summary>
    public partial class RunNotebookRequest
    {
        /// <summary> Initializes a new instance of <see cref="RunNotebookRequest"/>. </summary>
        public RunNotebookRequest()
        {
            Parameters = new ChangeTrackingDictionary<string, RunNotebookParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="RunNotebookRequest"/>. </summary>
        /// <param name="notebook"> Notebook name. </param>
        /// <param name="sparkPool"> SparkPool name. </param>
        /// <param name="sessionOptions"> Session properties. </param>
        /// <param name="honorSessionTimeToLive"> Whether session should run till time to live after run completes. </param>
        /// <param name="parameters"> Run notebook parameters. </param>
        internal RunNotebookRequest(string notebook, string sparkPool, RunNotebookSparkSessionOptions sessionOptions, bool? honorSessionTimeToLive, IDictionary<string, RunNotebookParameter> parameters)
        {
            Notebook = notebook;
            SparkPool = sparkPool;
            SessionOptions = sessionOptions;
            HonorSessionTimeToLive = honorSessionTimeToLive;
            Parameters = parameters;
        }

        /// <summary> Notebook name. </summary>
        public string Notebook { get; set; }
        /// <summary> SparkPool name. </summary>
        public string SparkPool { get; set; }
        /// <summary> Session properties. </summary>
        public RunNotebookSparkSessionOptions SessionOptions { get; set; }
        /// <summary> Whether session should run till time to live after run completes. </summary>
        public bool? HonorSessionTimeToLive { get; set; }
        /// <summary> Run notebook parameters. </summary>
        public IDictionary<string, RunNotebookParameter> Parameters { get; }
    }
}
