// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Run notebook error. </summary>
    public partial class RunNotebookError
    {
        /// <summary> Initializes a new instance of <see cref="RunNotebookError"/>. </summary>
        internal RunNotebookError()
        {
            Traceback = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="RunNotebookError"/>. </summary>
        /// <param name="ename"> Error name. </param>
        /// <param name="evalue"> Error message. </param>
        /// <param name="traceback"> Error trace. </param>
        internal RunNotebookError(string ename, string evalue, IReadOnlyList<string> traceback)
        {
            Ename = ename;
            Evalue = evalue;
            Traceback = traceback;
        }

        /// <summary> Error name. </summary>
        public string Ename { get; }
        /// <summary> Error message. </summary>
        public string Evalue { get; }
        /// <summary> Error trace. </summary>
        public IReadOnlyList<string> Traceback { get; }
    }
}
