// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> RerunTrigger resource type. </summary>
    public partial class RerunTriggerResource : SubResource
    {
        /// <summary> Initializes a new instance of <see cref="RerunTriggerResource"/>. </summary>
        /// <param name="properties"> Properties of the rerun trigger. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public RerunTriggerResource(RerunTumblingWindowTrigger properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="RerunTriggerResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of the rerun trigger. </param>
        internal RerunTriggerResource(string id, string name, string type, string etag, RerunTumblingWindowTrigger properties) : base(id, name, type, etag)
        {
            Properties = properties;
        }

        /// <summary> Properties of the rerun trigger. </summary>
        public RerunTumblingWindowTrigger Properties { get; set; }
    }
}
