// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A list of rerun triggers. </summary>
    public partial class RerunTriggerListResponse
    {
        /// <summary> Initializes a new instance of <see cref="RerunTriggerListResponse"/>. </summary>
        /// <param name="value"> List of rerun triggers. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RerunTriggerListResponse(IEnumerable<RerunTriggerResource> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="RerunTriggerListResponse"/>. </summary>
        /// <param name="value"> List of rerun triggers. </param>
        /// <param name="nextLink"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        internal RerunTriggerListResponse(IList<RerunTriggerResource> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List of rerun triggers. </summary>
        public IList<RerunTriggerResource> Value { get; }
        /// <summary> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </summary>
        public string NextLink { get; }
    }
}
