// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Enumerates possible request statuses. </summary>
    public readonly partial struct RequestStatus : IEquatable<RequestStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RequestStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RequestStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";

        /// <summary> Running. </summary>
        public static RequestStatus Running { get; } = new RequestStatus(RunningValue);
        /// <summary> Completed. </summary>
        public static RequestStatus Completed { get; } = new RequestStatus(CompletedValue);
        /// <summary> Failed. </summary>
        public static RequestStatus Failed { get; } = new RequestStatus(FailedValue);
        /// <summary> Determines if two <see cref="RequestStatus"/> values are the same. </summary>
        public static bool operator ==(RequestStatus left, RequestStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RequestStatus"/> values are not the same. </summary>
        public static bool operator !=(RequestStatus left, RequestStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RequestStatus"/>. </summary>
        public static implicit operator RequestStatus(string value) => new RequestStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RequestStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RequestStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
