// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Linked service for Quickbase. </summary>
    public partial class QuickbaseLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="QuickbaseLinkedService"/>. </summary>
        /// <param name="url"> The url to connect Quickbase source. Type: string (or Expression with resultType string). </param>
        /// <param name="userToken">
        /// The user token for the Quickbase source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/> or <paramref name="userToken"/> is null. </exception>
        public QuickbaseLinkedService(object url, SecretBase userToken)
        {
            Argument.AssertNotNull(url, nameof(url));
            Argument.AssertNotNull(userToken, nameof(userToken));

            Url = url;
            UserToken = userToken;
            Type = "Quickbase";
        }

        /// <summary> Initializes a new instance of <see cref="QuickbaseLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="url"> The url to connect Quickbase source. Type: string (or Expression with resultType string). </param>
        /// <param name="userToken">
        /// The user token for the Quickbase source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        internal QuickbaseLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object url, SecretBase userToken, object encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            Url = url;
            UserToken = userToken;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "Quickbase";
        }

        /// <summary> The url to connect Quickbase source. Type: string (or Expression with resultType string). </summary>
        public object Url { get; set; }
        /// <summary>
        /// The user token for the Quickbase source.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase UserToken { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public object EncryptedCredential { get; set; }
    }
}
