// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A list of active debug sessions. </summary>
    internal partial class QueryDataFlowDebugSessionsResponse
    {
        /// <summary> Initializes a new instance of <see cref="QueryDataFlowDebugSessionsResponse"/>. </summary>
        internal QueryDataFlowDebugSessionsResponse()
        {
            Value = new ChangeTrackingList<DataFlowDebugSessionInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="QueryDataFlowDebugSessionsResponse"/>. </summary>
        /// <param name="value"> Array with all active debug sessions. </param>
        /// <param name="nextLink"> The link to the next page of results, if any remaining results exist. </param>
        internal QueryDataFlowDebugSessionsResponse(IReadOnlyList<DataFlowDebugSessionInfo> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> Array with all active debug sessions. </summary>
        public IReadOnlyList<DataFlowDebugSessionInfo> Value { get; }
        /// <summary> The link to the next page of results, if any remaining results exist. </summary>
        public string NextLink { get; }
    }
}
