// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Power BI Workspace linked service. </summary>
    public partial class PowerBIWorkspaceLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="PowerBIWorkspaceLinkedService"/>. </summary>
        /// <param name="workspaceId"> The Power BI workspace id. </param>
        /// <param name="tenantId"> The tenant id to which the Power BI workspace belongs. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceId"/> or <paramref name="tenantId"/> is null. </exception>
        public PowerBIWorkspaceLinkedService(string workspaceId, string tenantId)
        {
            Argument.AssertNotNull(workspaceId, nameof(workspaceId));
            Argument.AssertNotNull(tenantId, nameof(tenantId));

            WorkspaceId = workspaceId;
            TenantId = tenantId;
            Type = "PowerBIWorkspace";
        }

        /// <summary> Initializes a new instance of <see cref="PowerBIWorkspaceLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="workspaceId"> The Power BI workspace id. </param>
        /// <param name="tenantId"> The tenant id to which the Power BI workspace belongs. </param>
        internal PowerBIWorkspaceLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, string workspaceId, string tenantId) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            WorkspaceId = workspaceId;
            TenantId = tenantId;
            Type = type ?? "PowerBIWorkspace";
        }

        /// <summary> The Power BI workspace id. </summary>
        public string WorkspaceId { get; set; }
        /// <summary> The tenant id to which the Power BI workspace belongs. </summary>
        public string TenantId { get; set; }
    }
}
