// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(PostgreSqlV2LinkedServiceConverter))]
    public partial class PostgreSqlV2LinkedService : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(Type);
            if (Optional.IsDefined(ConnectVia))
            {
                writer.WritePropertyName("connectVia"u8);
                writer.WriteObjectValue(ConnectVia);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsCollectionDefined(Parameters))
            {
                writer.WritePropertyName("parameters"u8);
                writer.WriteStartObject();
                foreach (var item in Parameters)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Annotations))
            {
                writer.WritePropertyName("annotations"u8);
                writer.WriteStartArray();
                foreach (var item in Annotations)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteObjectValue<object>(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("typeProperties"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("server"u8);
            writer.WriteObjectValue<object>(Server);
            if (Optional.IsDefined(Port))
            {
                writer.WritePropertyName("port"u8);
                writer.WriteObjectValue<object>(Port);
            }
            writer.WritePropertyName("username"u8);
            writer.WriteObjectValue<object>(Username);
            writer.WritePropertyName("database"u8);
            writer.WriteObjectValue<object>(Database);
            writer.WritePropertyName("sslMode"u8);
            writer.WriteObjectValue<object>(SslMode);
            if (Optional.IsDefined(Schema))
            {
                writer.WritePropertyName("schema"u8);
                writer.WriteObjectValue<object>(Schema);
            }
            if (Optional.IsDefined(Pooling))
            {
                writer.WritePropertyName("pooling"u8);
                writer.WriteObjectValue<object>(Pooling);
            }
            if (Optional.IsDefined(ConnectionTimeout))
            {
                writer.WritePropertyName("connectionTimeout"u8);
                writer.WriteObjectValue<object>(ConnectionTimeout);
            }
            if (Optional.IsDefined(CommandTimeout))
            {
                writer.WritePropertyName("commandTimeout"u8);
                writer.WriteObjectValue<object>(CommandTimeout);
            }
            if (Optional.IsDefined(TrustServerCertificate))
            {
                writer.WritePropertyName("trustServerCertificate"u8);
                writer.WriteObjectValue<object>(TrustServerCertificate);
            }
            if (Optional.IsDefined(SslCertificate))
            {
                writer.WritePropertyName("sslCertificate"u8);
                writer.WriteObjectValue<object>(SslCertificate);
            }
            if (Optional.IsDefined(SslKey))
            {
                writer.WritePropertyName("sslKey"u8);
                writer.WriteObjectValue<object>(SslKey);
            }
            if (Optional.IsDefined(SslPassword))
            {
                writer.WritePropertyName("sslPassword"u8);
                writer.WriteObjectValue<object>(SslPassword);
            }
            if (Optional.IsDefined(ReadBufferSize))
            {
                writer.WritePropertyName("readBufferSize"u8);
                writer.WriteObjectValue<object>(ReadBufferSize);
            }
            if (Optional.IsDefined(LogParameters))
            {
                writer.WritePropertyName("logParameters"u8);
                writer.WriteObjectValue<object>(LogParameters);
            }
            if (Optional.IsDefined(Timezone))
            {
                writer.WritePropertyName("timezone"u8);
                writer.WriteObjectValue<object>(Timezone);
            }
            if (Optional.IsDefined(Encoding))
            {
                writer.WritePropertyName("encoding"u8);
                writer.WriteObjectValue<object>(Encoding);
            }
            if (Optional.IsDefined(Password))
            {
                writer.WritePropertyName("password"u8);
                writer.WriteObjectValue(Password);
            }
            if (Optional.IsDefined(EncryptedCredential))
            {
                writer.WritePropertyName("encryptedCredential"u8);
                writer.WriteObjectValue<object>(EncryptedCredential);
            }
            writer.WriteEndObject();
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static PostgreSqlV2LinkedService DeserializePostgreSqlV2LinkedService(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            IntegrationRuntimeReference connectVia = default;
            string description = default;
            IDictionary<string, ParameterSpecification> parameters = default;
            IList<object> annotations = default;
            object server = default;
            object port = default;
            object username = default;
            object database = default;
            object sslMode = default;
            object schema = default;
            object pooling = default;
            object connectionTimeout = default;
            object commandTimeout = default;
            object trustServerCertificate = default;
            object sslCertificate = default;
            object sslKey = default;
            object sslPassword = default;
            object readBufferSize = default;
            object logParameters = default;
            object timezone = default;
            object encoding = default;
            AzureKeyVaultSecretReference password = default;
            object encryptedCredential = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("connectVia"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectVia = IntegrationRuntimeReference.DeserializeIntegrationRuntimeReference(property.Value);
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("parameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, ParameterSpecification> dictionary = new Dictionary<string, ParameterSpecification>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, ParameterSpecification.DeserializeParameterSpecification(property0.Value));
                    }
                    parameters = dictionary;
                    continue;
                }
                if (property.NameEquals("annotations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<object> array = new List<object>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(item.GetObject());
                        }
                    }
                    annotations = array;
                    continue;
                }
                if (property.NameEquals("typeProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("server"u8))
                        {
                            server = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("port"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            port = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("username"u8))
                        {
                            username = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("database"u8))
                        {
                            database = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("sslMode"u8))
                        {
                            sslMode = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("schema"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            schema = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("pooling"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            pooling = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("connectionTimeout"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectionTimeout = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("commandTimeout"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            commandTimeout = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("trustServerCertificate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            trustServerCertificate = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("sslCertificate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sslCertificate = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("sslKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sslKey = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("sslPassword"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sslPassword = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("readBufferSize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            readBufferSize = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("logParameters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            logParameters = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("timezone"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            timezone = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("encoding"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            encoding = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("password"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            password = AzureKeyVaultSecretReference.DeserializeAzureKeyVaultSecretReference(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("encryptedCredential"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            encryptedCredential = property0.Value.GetObject();
                            continue;
                        }
                    }
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new PostgreSqlV2LinkedService(
                type,
                connectVia,
                description,
                parameters ?? new ChangeTrackingDictionary<string, ParameterSpecification>(),
                annotations ?? new ChangeTrackingList<object>(),
                additionalProperties,
                server,
                port,
                username,
                database,
                sslMode,
                schema,
                pooling,
                connectionTimeout,
                commandTimeout,
                trustServerCertificate,
                sslCertificate,
                sslKey,
                sslPassword,
                readBufferSize,
                logParameters,
                timezone,
                encoding,
                password,
                encryptedCredential);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new PostgreSqlV2LinkedService FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePostgreSqlV2LinkedService(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class PostgreSqlV2LinkedServiceConverter : JsonConverter<PostgreSqlV2LinkedService>
        {
            public override void Write(Utf8JsonWriter writer, PostgreSqlV2LinkedService model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override PostgreSqlV2LinkedService Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializePostgreSqlV2LinkedService(document.RootElement);
            }
        }
    }
}
