// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A list pipeline runs. </summary>
    public partial class PipelineRunsQueryResponse
    {
        /// <summary> Initializes a new instance of <see cref="PipelineRunsQueryResponse"/>. </summary>
        /// <param name="value"> List of pipeline runs. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal PipelineRunsQueryResponse(IEnumerable<PipelineRun> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="PipelineRunsQueryResponse"/>. </summary>
        /// <param name="value"> List of pipeline runs. </param>
        /// <param name="continuationToken"> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </param>
        internal PipelineRunsQueryResponse(IReadOnlyList<PipelineRun> value, string continuationToken)
        {
            Value = value;
            ContinuationToken = continuationToken;
        }

        /// <summary> List of pipeline runs. </summary>
        public IReadOnlyList<PipelineRun> Value { get; }
        /// <summary> The continuation token for getting the next page of results, if any remaining results exist, null otherwise. </summary>
        public string ContinuationToken { get; }
    }
}
