// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Pipeline reference type. </summary>
    public partial class PipelineReference
    {
        /// <summary> Initializes a new instance of <see cref="PipelineReference"/>. </summary>
        /// <param name="type"> Pipeline reference type. </param>
        /// <param name="referenceName"> Reference pipeline name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="referenceName"/> is null. </exception>
        public PipelineReference(PipelineReferenceType type, string referenceName)
        {
            Argument.AssertNotNull(referenceName, nameof(referenceName));

            Type = type;
            ReferenceName = referenceName;
        }

        /// <summary> Initializes a new instance of <see cref="PipelineReference"/>. </summary>
        /// <param name="type"> Pipeline reference type. </param>
        /// <param name="referenceName"> Reference pipeline name. </param>
        /// <param name="name"> Reference name. </param>
        internal PipelineReference(PipelineReferenceType type, string referenceName, string name)
        {
            Type = type;
            ReferenceName = referenceName;
            Name = name;
        }

        /// <summary> Pipeline reference type. </summary>
        public PipelineReferenceType Type { get; set; }
        /// <summary> Reference pipeline name. </summary>
        public string ReferenceName { get; set; }
        /// <summary> Reference name. </summary>
        public string Name { get; set; }
    }
}
