// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(PipelineListResponseConverter))]
    internal partial class PipelineListResponse
    {
        internal static PipelineListResponse DeserializePipelineListResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<PipelineResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<PipelineResource> array = new List<PipelineResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PipelineResource.DeserializePipelineResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new PipelineListResponse(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PipelineListResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePipelineListResponse(document.RootElement);
        }

        internal partial class PipelineListResponseConverter : JsonConverter<PipelineListResponse>
        {
            public override void Write(Utf8JsonWriter writer, PipelineListResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override PipelineListResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializePipelineListResponse(document.RootElement);
            }
        }
    }
}
