// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The OrcCompressionCodec. </summary>
    internal readonly partial struct OrcCompressionCodec : IEquatable<OrcCompressionCodec>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrcCompressionCodec"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrcCompressionCodec(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string ZlibValue = "zlib";
        private const string SnappyValue = "snappy";
        private const string LzoValue = "lzo";

        /// <summary> none. </summary>
        public static OrcCompressionCodec None { get; } = new OrcCompressionCodec(NoneValue);
        /// <summary> zlib. </summary>
        public static OrcCompressionCodec Zlib { get; } = new OrcCompressionCodec(ZlibValue);
        /// <summary> snappy. </summary>
        public static OrcCompressionCodec Snappy { get; } = new OrcCompressionCodec(SnappyValue);
        /// <summary> lzo. </summary>
        public static OrcCompressionCodec Lzo { get; } = new OrcCompressionCodec(LzoValue);
        /// <summary> Determines if two <see cref="OrcCompressionCodec"/> values are the same. </summary>
        public static bool operator ==(OrcCompressionCodec left, OrcCompressionCodec right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrcCompressionCodec"/> values are not the same. </summary>
        public static bool operator !=(OrcCompressionCodec left, OrcCompressionCodec right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrcCompressionCodec"/>. </summary>
        public static implicit operator OrcCompressionCodec(string value) => new OrcCompressionCodec(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrcCompressionCodec other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrcCompressionCodec other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
