// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The partition mechanism that will be used for Oracle read in parallel. </summary>
    public readonly partial struct OraclePartitionOption : IEquatable<OraclePartitionOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OraclePartitionOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OraclePartitionOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PhysicalPartitionsOfTableValue = "PhysicalPartitionsOfTable";
        private const string DynamicRangeValue = "DynamicRange";

        /// <summary> None. </summary>
        public static OraclePartitionOption None { get; } = new OraclePartitionOption(NoneValue);
        /// <summary> PhysicalPartitionsOfTable. </summary>
        public static OraclePartitionOption PhysicalPartitionsOfTable { get; } = new OraclePartitionOption(PhysicalPartitionsOfTableValue);
        /// <summary> DynamicRange. </summary>
        public static OraclePartitionOption DynamicRange { get; } = new OraclePartitionOption(DynamicRangeValue);
        /// <summary> Determines if two <see cref="OraclePartitionOption"/> values are the same. </summary>
        public static bool operator ==(OraclePartitionOption left, OraclePartitionOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OraclePartitionOption"/> values are not the same. </summary>
        public static bool operator !=(OraclePartitionOption left, OraclePartitionOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OraclePartitionOption"/>. </summary>
        public static implicit operator OraclePartitionOption(string value) => new OraclePartitionOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OraclePartitionOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OraclePartitionOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
