// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity source for an Office 365 service. </summary>
    public partial class Office365Source : CopySource
    {
        /// <summary> Initializes a new instance of <see cref="Office365Source"/>. </summary>
        public Office365Source()
        {
            Type = "Office365Source";
        }

        /// <summary> Initializes a new instance of <see cref="Office365Source"/>. </summary>
        /// <param name="type"> Copy source type. </param>
        /// <param name="sourceRetryCount"> Source retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sourceRetryWait"> Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="allowedGroups"> The groups containing all the users. Type: array of strings (or Expression with resultType array of strings). </param>
        /// <param name="userScopeFilterUri"> The user scope uri. Type: string (or Expression with resultType string). </param>
        /// <param name="dateFilterColumn"> The Column to apply the &lt;paramref name="StartTime"/&gt; and &lt;paramref name="EndTime"/&gt;. Type: string (or Expression with resultType string). </param>
        /// <param name="startTime"> Start time of the requested range for this dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="endTime"> End time of the requested range for this dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="outputColumns"> The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn.  Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]. </param>
        internal Office365Source(string type, object sourceRetryCount, object sourceRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object allowedGroups, object userScopeFilterUri, object dateFilterColumn, object startTime, object endTime, object outputColumns) : base(type, sourceRetryCount, sourceRetryWait, maxConcurrentConnections, additionalProperties)
        {
            AllowedGroups = allowedGroups;
            UserScopeFilterUri = userScopeFilterUri;
            DateFilterColumn = dateFilterColumn;
            StartTime = startTime;
            EndTime = endTime;
            OutputColumns = outputColumns;
            Type = type ?? "Office365Source";
        }

        /// <summary> The groups containing all the users. Type: array of strings (or Expression with resultType array of strings). </summary>
        public object AllowedGroups { get; set; }
        /// <summary> The user scope uri. Type: string (or Expression with resultType string). </summary>
        public object UserScopeFilterUri { get; set; }
        /// <summary> The Column to apply the &lt;paramref name="StartTime"/&gt; and &lt;paramref name="EndTime"/&gt;. Type: string (or Expression with resultType string). </summary>
        public object DateFilterColumn { get; set; }
        /// <summary> Start time of the requested range for this dataset. Type: string (or Expression with resultType string). </summary>
        public object StartTime { get; set; }
        /// <summary> End time of the requested range for this dataset. Type: string (or Expression with resultType string). </summary>
        public object EndTime { get; set; }
        /// <summary> The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects). itemType: OutputColumn.  Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]. </summary>
        public object OutputColumns { get; set; }
    }
}
