// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Notebook cell. </summary>
    public partial class NotebookCell
    {
        /// <summary> Initializes a new instance of <see cref="NotebookCell"/>. </summary>
        /// <param name="cellType"> String identifying the type of cell. </param>
        /// <param name="metadata"> Cell-level metadata. </param>
        /// <param name="source"> Contents of the cell, represented as an array of lines. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cellType"/>, <paramref name="metadata"/> or <paramref name="source"/> is null. </exception>
        public NotebookCell(string cellType, object metadata, IEnumerable<string> source)
        {
            Argument.AssertNotNull(cellType, nameof(cellType));
            Argument.AssertNotNull(metadata, nameof(metadata));
            Argument.AssertNotNull(source, nameof(source));

            CellType = cellType;
            Metadata = metadata;
            Source = source.ToList();
            Outputs = new ChangeTrackingList<NotebookCellOutputItem>();
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="NotebookCell"/>. </summary>
        /// <param name="cellType"> String identifying the type of cell. </param>
        /// <param name="metadata"> Cell-level metadata. </param>
        /// <param name="source"> Contents of the cell, represented as an array of lines. </param>
        /// <param name="attachments"> Attachments associated with the cell. </param>
        /// <param name="outputs"> Cell-level output items. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal NotebookCell(string cellType, object metadata, IList<string> source, object attachments, IList<NotebookCellOutputItem> outputs, IDictionary<string, object> additionalProperties)
        {
            CellType = cellType;
            Metadata = metadata;
            Source = source;
            Attachments = attachments;
            Outputs = outputs;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> String identifying the type of cell. </summary>
        public string CellType { get; set; }
        /// <summary> Cell-level metadata. </summary>
        public object Metadata { get; set; }
        /// <summary> Contents of the cell, represented as an array of lines. </summary>
        public IList<string> Source { get; }
        /// <summary> Attachments associated with the cell. </summary>
        public object Attachments { get; set; }
        /// <summary> Cell-level output items. </summary>
        public IList<NotebookCellOutputItem> Outputs { get; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
