// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(NotebookConverter))]
    public partial class Notebook : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(BigDataPool))
            {
                if (BigDataPool != null)
                {
                    writer.WritePropertyName("bigDataPool"u8);
                    writer.WriteObjectValue(BigDataPool);
                }
                else
                {
                    writer.WriteNull("bigDataPool");
                }
            }
            if (Optional.IsDefined(TargetSparkConfiguration))
            {
                writer.WritePropertyName("targetSparkConfiguration"u8);
                writer.WriteObjectValue(TargetSparkConfiguration);
            }
            if (Optional.IsDefined(SessionProperties))
            {
                if (SessionProperties != null)
                {
                    writer.WritePropertyName("sessionProperties"u8);
                    writer.WriteObjectValue(SessionProperties);
                }
                else
                {
                    writer.WriteNull("sessionProperties");
                }
            }
            writer.WritePropertyName("metadata"u8);
            writer.WriteObjectValue(Metadata);
            writer.WritePropertyName("nbformat"u8);
            writer.WriteNumberValue(NotebookFormat);
            writer.WritePropertyName("nbformat_minor"u8);
            writer.WriteNumberValue(NotebookFormatMinor);
            writer.WritePropertyName("cells"u8);
            writer.WriteStartArray();
            foreach (var item in Cells)
            {
                writer.WriteObjectValue(item);
            }
            writer.WriteEndArray();
            if (Optional.IsDefined(Folder))
            {
                if (Folder != null)
                {
                    writer.WritePropertyName("folder"u8);
                    writer.WriteObjectValue(Folder);
                }
                else
                {
                    writer.WriteNull("folder");
                }
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static Notebook DeserializeNotebook(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string description = default;
            BigDataPoolReference bigDataPool = default;
            SparkConfigurationReference targetSparkConfiguration = default;
            NotebookSessionProperties sessionProperties = default;
            NotebookMetadata metadata = default;
            int nbformat = default;
            int nbformatMinor = default;
            IList<NotebookCell> cells = default;
            NotebookFolder folder = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bigDataPool"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        bigDataPool = null;
                        continue;
                    }
                    bigDataPool = BigDataPoolReference.DeserializeBigDataPoolReference(property.Value);
                    continue;
                }
                if (property.NameEquals("targetSparkConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetSparkConfiguration = SparkConfigurationReference.DeserializeSparkConfigurationReference(property.Value);
                    continue;
                }
                if (property.NameEquals("sessionProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        sessionProperties = null;
                        continue;
                    }
                    sessionProperties = NotebookSessionProperties.DeserializeNotebookSessionProperties(property.Value);
                    continue;
                }
                if (property.NameEquals("metadata"u8))
                {
                    metadata = NotebookMetadata.DeserializeNotebookMetadata(property.Value);
                    continue;
                }
                if (property.NameEquals("nbformat"u8))
                {
                    nbformat = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("nbformat_minor"u8))
                {
                    nbformatMinor = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cells"u8))
                {
                    List<NotebookCell> array = new List<NotebookCell>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NotebookCell.DeserializeNotebookCell(item));
                    }
                    cells = array;
                    continue;
                }
                if (property.NameEquals("folder"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        folder = null;
                        continue;
                    }
                    folder = NotebookFolder.DeserializeNotebookFolder(property.Value);
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new Notebook(
                description,
                bigDataPool,
                targetSparkConfiguration,
                sessionProperties,
                metadata,
                nbformat,
                nbformatMinor,
                cells,
                folder,
                additionalProperties);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Notebook FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeNotebook(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class NotebookConverter : JsonConverter<Notebook>
        {
            public override void Write(Utf8JsonWriter writer, Notebook model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override Notebook Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeNotebook(document.RootElement);
            }
        }
    }
}
