// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The authentication type to be used to connect to the MongoDB database. </summary>
    public readonly partial struct MongoDbAuthenticationType : IEquatable<MongoDbAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoDbAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoDbAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string AnonymousValue = "Anonymous";

        /// <summary> Basic. </summary>
        public static MongoDbAuthenticationType Basic { get; } = new MongoDbAuthenticationType(BasicValue);
        /// <summary> Anonymous. </summary>
        public static MongoDbAuthenticationType Anonymous { get; } = new MongoDbAuthenticationType(AnonymousValue);
        /// <summary> Determines if two <see cref="MongoDbAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(MongoDbAuthenticationType left, MongoDbAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoDbAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(MongoDbAuthenticationType left, MongoDbAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoDbAuthenticationType"/>. </summary>
        public static implicit operator MongoDbAuthenticationType(string value) => new MongoDbAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoDbAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoDbAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
