// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(MetastoreUpdationResponseConverter))]
    public partial class MetastoreUpdationResponse
    {
        internal static MetastoreUpdationResponse DeserializeMetastoreUpdationResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RequestStatus? status = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new RequestStatus(property.Value.GetString());
                    continue;
                }
            }
            return new MetastoreUpdationResponse(status);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetastoreUpdationResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetastoreUpdationResponse(document.RootElement);
        }

        internal partial class MetastoreUpdationResponseConverter : JsonConverter<MetastoreUpdationResponse>
        {
            public override void Write(Utf8JsonWriter writer, MetastoreUpdationResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override MetastoreUpdationResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeMetastoreUpdationResponse(document.RootElement);
            }
        }
    }
}
