// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Managed Virtual Network Settings. </summary>
    public partial class ManagedVirtualNetworkSettings
    {
        /// <summary> Initializes a new instance of <see cref="ManagedVirtualNetworkSettings"/>. </summary>
        public ManagedVirtualNetworkSettings()
        {
            AllowedAadTenantIdsForLinking = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedVirtualNetworkSettings"/>. </summary>
        /// <param name="preventDataExfiltration"> Prevent Data Exfiltration. </param>
        /// <param name="linkedAccessCheckOnTargetResource"> Linked Access Check On Target Resource. </param>
        /// <param name="allowedAadTenantIdsForLinking"> Allowed Aad Tenant Ids For Linking. </param>
        internal ManagedVirtualNetworkSettings(bool? preventDataExfiltration, bool? linkedAccessCheckOnTargetResource, IList<string> allowedAadTenantIdsForLinking)
        {
            PreventDataExfiltration = preventDataExfiltration;
            LinkedAccessCheckOnTargetResource = linkedAccessCheckOnTargetResource;
            AllowedAadTenantIdsForLinking = allowedAadTenantIdsForLinking;
        }

        /// <summary> Prevent Data Exfiltration. </summary>
        public bool? PreventDataExfiltration { get; set; }
        /// <summary> Linked Access Check On Target Resource. </summary>
        public bool? LinkedAccessCheckOnTargetResource { get; set; }
        /// <summary> Allowed Aad Tenant Ids For Linking. </summary>
        public IList<string> AllowedAadTenantIdsForLinking { get; }
    }
}
