// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Log settings. </summary>
    public partial class LogSettings
    {
        /// <summary> Initializes a new instance of <see cref="LogSettings"/>. </summary>
        /// <param name="logLocationSettings"> Log location settings customer needs to provide when enabling log. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="logLocationSettings"/> is null. </exception>
        public LogSettings(LogLocationSettings logLocationSettings)
        {
            Argument.AssertNotNull(logLocationSettings, nameof(logLocationSettings));

            LogLocationSettings = logLocationSettings;
        }

        /// <summary> Initializes a new instance of <see cref="LogSettings"/>. </summary>
        /// <param name="enableCopyActivityLog"> Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="copyActivityLogSettings"> Specifies settings for copy activity log. </param>
        /// <param name="logLocationSettings"> Log location settings customer needs to provide when enabling log. </param>
        internal LogSettings(object enableCopyActivityLog, CopyActivityLogSettings copyActivityLogSettings, LogLocationSettings logLocationSettings)
        {
            EnableCopyActivityLog = enableCopyActivityLog;
            CopyActivityLogSettings = copyActivityLogSettings;
            LogLocationSettings = logLocationSettings;
        }

        /// <summary> Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean). </summary>
        public object EnableCopyActivityLog { get; set; }
        /// <summary> Specifies settings for copy activity log. </summary>
        public CopyActivityLogSettings CopyActivityLogSettings { get; set; }
        /// <summary> Log location settings customer needs to provide when enabling log. </summary>
        public LogLocationSettings LogLocationSettings { get; set; }
    }
}
