// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts
{
    /// <summary> Linked service reference type. </summary>
    public readonly partial struct LinkedServiceReferenceType : IEquatable<LinkedServiceReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinkedServiceReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinkedServiceReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LinkedServiceReferenceValue = "LinkedServiceReference";

        /// <summary> LinkedServiceReference. </summary>
        public static LinkedServiceReferenceType LinkedServiceReference { get; } = new LinkedServiceReferenceType(LinkedServiceReferenceValue);
        /// <summary> Determines if two <see cref="LinkedServiceReferenceType"/> values are the same. </summary>
        public static bool operator ==(LinkedServiceReferenceType left, LinkedServiceReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinkedServiceReferenceType"/> values are not the same. </summary>
        public static bool operator !=(LinkedServiceReferenceType left, LinkedServiceReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinkedServiceReferenceType"/>. </summary>
        public static implicit operator LinkedServiceReferenceType(string value) => new LinkedServiceReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinkedServiceReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinkedServiceReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
