// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A list of linked service resources. </summary>
    internal partial class LinkedServiceListResponse
    {
        /// <summary> Initializes a new instance of <see cref="LinkedServiceListResponse"/>. </summary>
        /// <param name="value"> List of linked services. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal LinkedServiceListResponse(IEnumerable<LinkedServiceResource> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="LinkedServiceListResponse"/>. </summary>
        /// <param name="value"> List of linked services. </param>
        /// <param name="nextLink"> The link to the next page of results, if any remaining results exist. </param>
        internal LinkedServiceListResponse(IReadOnlyList<LinkedServiceResource> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List of linked services. </summary>
        public IReadOnlyList<LinkedServiceResource> Value { get; }
        /// <summary> The link to the next page of results, if any remaining results exist. </summary>
        public string NextLink { get; }
    }
}
