// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(LinkTableStatusConverter))]
    public partial class LinkTableStatus
    {
        internal static LinkTableStatus DeserializeLinkTableStatus(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string status = default;
            string errorMessage = default;
            object startTime = default;
            object stopTime = default;
            string linkTableId = default;
            string errorCode = default;
            DateTimeOffset? lastProcessedData = default;
            DateTimeOffset? lastTransactionCommitTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorMessage"u8))
                {
                    errorMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("stopTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stopTime = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("linkTableId"u8))
                {
                    linkTableId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    errorCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastProcessedData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastProcessedData = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastTransactionCommitTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastTransactionCommitTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new LinkTableStatus(
                id,
                status,
                errorMessage,
                startTime,
                stopTime,
                linkTableId,
                errorCode,
                lastProcessedData,
                lastTransactionCommitTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LinkTableStatus FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLinkTableStatus(document.RootElement);
        }

        internal partial class LinkTableStatusConverter : JsonConverter<LinkTableStatus>
        {
            public override void Write(Utf8JsonWriter writer, LinkTableStatus model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override LinkTableStatus Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeLinkTableStatus(document.RootElement);
            }
        }
    }
}
