// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The LinkTableResource. </summary>
    public partial class LinkTableResource
    {
        /// <summary> Initializes a new instance of <see cref="LinkTableResource"/>. </summary>
        internal LinkTableResource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinkTableResource"/>. </summary>
        /// <param name="id"> Link table id. </param>
        /// <param name="name"> Link table name. </param>
        /// <param name="source"> Source table properties for link table request. </param>
        /// <param name="target"> Target table properties for link table request. </param>
        internal LinkTableResource(string id, string name, LinkTableRequestSource source, LinkTableRequestTarget target)
        {
            Id = id;
            Name = name;
            Source = source;
            Target = target;
        }

        /// <summary> Link table id. </summary>
        public string Id { get; }
        /// <summary> Link table name. </summary>
        public string Name { get; }
        /// <summary> Source table properties for link table request. </summary>
        public LinkTableRequestSource Source { get; }
        /// <summary> Target table properties for link table request. </summary>
        public LinkTableRequestTarget Target { get; }
    }
}
