// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(LinkTableRequestTargetDistributionOptionsConverter))]
    public partial class LinkTableRequestTargetDistributionOptions : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Type))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(Type);
            }
            if (Optional.IsDefined(DistributionColumn))
            {
                writer.WritePropertyName("distributionColumn"u8);
                writer.WriteStringValue(DistributionColumn);
            }
            writer.WriteEndObject();
        }

        internal static LinkTableRequestTargetDistributionOptions DeserializeLinkTableRequestTargetDistributionOptions(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            string distributionColumn = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("distributionColumn"u8))
                {
                    distributionColumn = property.Value.GetString();
                    continue;
                }
            }
            return new LinkTableRequestTargetDistributionOptions(type, distributionColumn);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LinkTableRequestTargetDistributionOptions FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLinkTableRequestTargetDistributionOptions(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class LinkTableRequestTargetDistributionOptionsConverter : JsonConverter<LinkTableRequestTargetDistributionOptions>
        {
            public override void Write(Utf8JsonWriter writer, LinkTableRequestTargetDistributionOptions model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override LinkTableRequestTargetDistributionOptions Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeLinkTableRequestTargetDistributionOptions(document.RootElement);
            }
        }
    }
}
