// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(LinkConnectionTargetDatabaseTypePropertiesConverter))]
    public partial class LinkConnectionTargetDatabaseTypeProperties : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(CrossTableTransaction))
            {
                writer.WritePropertyName("crossTableTransaction"u8);
                writer.WriteBooleanValue(CrossTableTransaction.Value);
            }
            if (Optional.IsDefined(DropExistingTargetTableOnStart))
            {
                writer.WritePropertyName("dropExistingTargetTableOnStart"u8);
                writer.WriteBooleanValue(DropExistingTargetTableOnStart.Value);
            }
            if (Optional.IsDefined(ActionOnExistingTargetTable))
            {
                writer.WritePropertyName("actionOnExistingTargetTable"u8);
                writer.WriteStringValue(ActionOnExistingTargetTable.Value.ToString());
            }
            writer.WriteEndObject();
        }

        internal static LinkConnectionTargetDatabaseTypeProperties DeserializeLinkConnectionTargetDatabaseTypeProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? crossTableTransaction = default;
            bool? dropExistingTargetTableOnStart = default;
            ActionOnExistingTargetTable? actionOnExistingTargetTable = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("crossTableTransaction"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    crossTableTransaction = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dropExistingTargetTableOnStart"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dropExistingTargetTableOnStart = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("actionOnExistingTargetTable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    actionOnExistingTargetTable = new ActionOnExistingTargetTable(property.Value.GetString());
                    continue;
                }
            }
            return new LinkConnectionTargetDatabaseTypeProperties(crossTableTransaction, dropExistingTargetTableOnStart, actionOnExistingTargetTable);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LinkConnectionTargetDatabaseTypeProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLinkConnectionTargetDatabaseTypeProperties(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class LinkConnectionTargetDatabaseTypePropertiesConverter : JsonConverter<LinkConnectionTargetDatabaseTypeProperties>
        {
            public override void Write(Utf8JsonWriter writer, LinkConnectionTargetDatabaseTypeProperties model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override LinkConnectionTargetDatabaseTypeProperties Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeLinkConnectionTargetDatabaseTypeProperties(document.RootElement);
            }
        }
    }
}
