// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(LinkConnectionRefreshStatusConverter))]
    public partial class LinkConnectionRefreshStatus
    {
        internal static LinkConnectionRefreshStatus DeserializeLinkConnectionRefreshStatus(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string refreshStatus = default;
            string errorMessage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("refreshStatus"u8))
                {
                    refreshStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorMessage"u8))
                {
                    errorMessage = property.Value.GetString();
                    continue;
                }
            }
            return new LinkConnectionRefreshStatus(refreshStatus, errorMessage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LinkConnectionRefreshStatus FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLinkConnectionRefreshStatus(document.RootElement);
        }

        internal partial class LinkConnectionRefreshStatusConverter : JsonConverter<LinkConnectionRefreshStatus>
        {
            public override void Write(Utf8JsonWriter writer, LinkConnectionRefreshStatus model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override LinkConnectionRefreshStatus Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeLinkConnectionRefreshStatus(document.RootElement);
            }
        }
    }
}
