// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The LinkConnectionListResponse. </summary>
    internal partial class LinkConnectionListResponse
    {
        /// <summary> Initializes a new instance of <see cref="LinkConnectionListResponse"/>. </summary>
        /// <param name="value"> List link connection value. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal LinkConnectionListResponse(IEnumerable<LinkConnectionResource> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="LinkConnectionListResponse"/>. </summary>
        /// <param name="value"> List link connection value. </param>
        /// <param name="nextLink"> List link connections next link. </param>
        internal LinkConnectionListResponse(IReadOnlyList<LinkConnectionResource> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List link connection value. </summary>
        public IReadOnlyList<LinkConnectionResource> Value { get; }
        /// <summary> List link connections next link. </summary>
        public string NextLink { get; }
    }
}
