// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The LinkConnectionLandingZone. </summary>
    public partial class LinkConnectionLandingZone
    {
        /// <summary> Initializes a new instance of <see cref="LinkConnectionLandingZone"/>. </summary>
        public LinkConnectionLandingZone()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinkConnectionLandingZone"/>. </summary>
        /// <param name="linkedService"> Linked service reference. </param>
        /// <param name="fileSystem"> Landing zone's file system name. </param>
        /// <param name="folderPath"> Landing zone's folder path name. </param>
        /// <param name="sasToken"> Landing zone's sas token. </param>
        internal LinkConnectionLandingZone(LinkedServiceReference linkedService, string fileSystem, string folderPath, SecureString sasToken)
        {
            LinkedService = linkedService;
            FileSystem = fileSystem;
            FolderPath = folderPath;
            SasToken = sasToken;
        }

        /// <summary> Linked service reference. </summary>
        public LinkedServiceReference LinkedService { get; set; }
        /// <summary> Landing zone's file system name. </summary>
        public string FileSystem { get; set; }
        /// <summary> Landing zone's folder path name. </summary>
        public string FolderPath { get; set; }
        /// <summary> Landing zone's sas token. </summary>
        public SecureString SasToken { get; set; }
    }
}
