// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The LinkConnection. </summary>
    public partial class LinkConnection
    {
        /// <summary> Initializes a new instance of <see cref="LinkConnection"/>. </summary>
        public LinkConnection()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinkConnection"/>. </summary>
        /// <param name="sourceDatabase"> Properties of link connection's source database. </param>
        /// <param name="targetDatabase"> Properties of link connection's target database. </param>
        /// <param name="landingZone"> Properties of link connection's landing zone. </param>
        /// <param name="compute"> Properties of link connection's compute. </param>
        internal LinkConnection(LinkConnectionSourceDatabase sourceDatabase, LinkConnectionTargetDatabase targetDatabase, LinkConnectionLandingZone landingZone, LinkConnectionCompute compute)
        {
            SourceDatabase = sourceDatabase;
            TargetDatabase = targetDatabase;
            LandingZone = landingZone;
            Compute = compute;
        }

        /// <summary> Properties of link connection's source database. </summary>
        public LinkConnectionSourceDatabase SourceDatabase { get; set; }
        /// <summary> Properties of link connection's target database. </summary>
        public LinkConnectionTargetDatabase TargetDatabase { get; set; }
        /// <summary> Properties of link connection's landing zone. </summary>
        public LinkConnectionLandingZone LandingZone { get; set; }
        /// <summary> Properties of link connection's compute. </summary>
        public LinkConnectionCompute Compute { get; set; }
    }
}
