// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(LibraryListResponseConverter))]
    internal partial class LibraryListResponse
    {
        internal static LibraryListResponse DeserializeLibraryListResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<LibraryResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<LibraryResource> array = new List<LibraryResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LibraryResource.DeserializeLibraryResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new LibraryListResponse(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LibraryListResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLibraryListResponse(document.RootElement);
        }

        internal partial class LibraryListResponseConverter : JsonConverter<LibraryListResponse>
        {
            public override void Write(Utf8JsonWriter writer, LibraryListResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override LibraryListResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeLibraryListResponse(document.RootElement);
            }
        }
    }
}
