// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The location of Microsoft Fabric LakeHouse Files dataset. </summary>
    public partial class LakeHouseLocation : DatasetLocation
    {
        /// <summary> Initializes a new instance of <see cref="LakeHouseLocation"/>. </summary>
        public LakeHouseLocation()
        {
            Type = "LakeHouseLocation";
        }

        /// <summary> Initializes a new instance of <see cref="LakeHouseLocation"/>. </summary>
        /// <param name="type"> Type of dataset storage location. </param>
        /// <param name="folderPath"> Specify the folder path of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="fileName"> Specify the file name of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal LakeHouseLocation(string type, object folderPath, object fileName, IDictionary<string, object> additionalProperties) : base(type, folderPath, fileName, additionalProperties)
        {
            Type = type ?? "LakeHouseLocation";
        }
    }
}
