// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(KqlScriptsResourceCollectionResponseConverter))]
    internal partial class KqlScriptsResourceCollectionResponse
    {
        internal static KqlScriptsResourceCollectionResponse DeserializeKqlScriptsResourceCollectionResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<KqlScriptResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KqlScriptResource> array = new List<KqlScriptResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KqlScriptResource.DeserializeKqlScriptResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new KqlScriptsResourceCollectionResponse(value ?? new ChangeTrackingList<KqlScriptResource>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static KqlScriptsResourceCollectionResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeKqlScriptsResourceCollectionResponse(document.RootElement);
        }

        internal partial class KqlScriptsResourceCollectionResponseConverter : JsonConverter<KqlScriptsResourceCollectionResponse>
        {
            public override void Write(Utf8JsonWriter writer, KqlScriptsResourceCollectionResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override KqlScriptsResourceCollectionResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeKqlScriptsResourceCollectionResponse(document.RootElement);
            }
        }
    }
}
