// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(KqlScriptConverter))]
    public partial class KqlScript : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Content))
            {
                writer.WritePropertyName("content"u8);
                writer.WriteObjectValue(Content);
            }
            writer.WriteEndObject();
        }

        internal static KqlScript DeserializeKqlScript(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            KqlScriptContent content = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("content"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    content = KqlScriptContent.DeserializeKqlScriptContent(property.Value);
                    continue;
                }
            }
            return new KqlScript(content);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static KqlScript FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeKqlScript(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class KqlScriptConverter : JsonConverter<KqlScript>
        {
            public override void Write(Utf8JsonWriter writer, KqlScript model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override KqlScript Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeKqlScript(document.RootElement);
            }
        }
    }
}
